<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Translatable\HasTranslations;

class Broadcast extends Model
{
    use HasFactory, SoftDeletes , HasTranslations;
    protected $table = "broadcasts";
    public $translatable = ['name','description'];
    protected $fillable = ['therapist_id','therapist_community_id', 'broadcast_category_id', 'is_featured', 'name', 'description', 'slug', 'sort_order', 'image','file_type','link_type','file_url','audio','video', 'is_active', 'deleted_at'];


    public function scopeWithAll($query)
    {
        return $query->with('tags')->with('therapist')->with('therapist_community')->with('broadcast_category');
    }
    public function scopeHasModulePermissions($query){
        return $query->whereHas('therapist',function($q){
            $q->whereHas('pricing_plan',function($y){{
                $y->whereHas('therapist_modules',function($z){
                    $z->where('pricing_plan_modules.module_code','therapist-broadcast');
                });
            }});
        })->orWhereHas('therapist_community',function($q){
            $q->whereHas('pricing_plan',function($y){{
                $y->whereHas('therapist_community_modules',function($z){
                    $z->where('pricing_plan_modules.module_code','therapist_community-broadcast');
                });
            }});
        })->doesntHave('therapist', 'or')->doesntHave('therapist_community' , 'or');
    }
    public function scopeActive($query)
    {
        return $query->where('is_active', 1);
    }
    public function scopeFeatured($query)
    {
        return $query->where('is_featured', 1);
    }
    public function therapist()
    {
        return $this->belongsTo(Therapist::class);
    }
    public function therapist_community()
    {
        return $this->belongsTo(TherapistCommunity::class);
    }
    public function broadcast_category()
    {
        return $this->belongsTo(BroadcastCategory::class);
    }
    public function tags()
    {
        return $this->belongsToMany(Tag::class, 'broadcast_tag');
    }
}
